/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.mtp.MTPException;
import jade.mtp.http.BasicFipaDateTime;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCodec
extends DefaultHandler {
    public static final String PREAMBUL = "<?xml version=\"1.0\"?>\n";
    public static final String ENVELOPE_TAG = "envelope";
    public static final String PARAMS_TAG = "params";
    public static final String INDEX = "index";
    public static final String INDEX_ATTR = " index=\"";
    public static final String TO_TAG = "to";
    public static final String AID_TAG = "agent-identifier";
    public static final String AID_NAME = "name";
    public static final String AID_ADDRESSES = "addresses";
    public static final String AID_ADDRESS = "url";
    public static final String FROM_TAG = "from";
    public static final String COMMENTS_TAG = "comments";
    public static final String REPRESENTATION_TAG = "acl-representation";
    public static final String LENGTH_TAG = "payload-length";
    public static final String ENCODING_TAG = "payload-encoding";
    public static final String DATE_TAG = "date";
    public static final String INTENDED_TAG = "intended-receiver";
    public static final String RECEIVED_TAG = "received";
    public static final String RECEIVED_DATE = "received-date";
    public static final String RECEIVED_BY = "received-by";
    public static final String RECEIVED_FROM = "received-from";
    public static final String RECEIVED_ID = "received-id";
    public static final String RECEIVED_VIA = "received-via";
    public static final String RECEIVED_ATTR = "value";
    public static final String PROP_TAG = "user-defined";
    public static final String PROP_ATTR = "href";
    public static final String PROP_ATTR_TYPE = "type";
    public static final String PROP_STRING_TYPE = "string";
    public static final String PROP_BYTE_TYPE = "byte-array";
    public static final String PROP_SER_TYPE = "serialized";
    public static final String OT = "<";
    public static final String ET = "</";
    public static final String CT = ">";
    public static final String NULL = "";
    private XMLReader parser = null;
    private Envelope env = null;
    private ReceivedObject ro = null;
    private AID aid = null;
    private Property prop = null;
    private StringBuffer accumulator;
    private String propType;
    private static Logger logger = Logger.getMyLogger((class$jade$mtp$http$XMLCodec == null ? (class$jade$mtp$http$XMLCodec = XMLCodec.class$("jade.mtp.http.XMLCodec")) : class$jade$mtp$http$XMLCodec).getName());
    static /* synthetic */ Class class$jade$mtp$http$XMLCodec;

    public XMLCodec(String parserClass) throws MTPException {
        try {
            this.parser = (XMLReader)Class.forName(parserClass).newInstance();
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
        }
        catch (Exception e) {
            throw new MTPException(e.toString());
        }
    }

    private static void encodeAid(StringBuffer sb, AID aid) {
        sb.append(OT).append(AID_TAG).append(CT);
        XMLCodec.encodeTag(sb, AID_NAME, aid.getName());
        sb.append(OT).append(AID_ADDRESSES).append(CT);
        String[] addresses = aid.getAddressesArray();
        int i = 0;
        while (i < addresses.length) {
            XMLCodec.encodeTag(sb, AID_ADDRESS, addresses[i]);
            ++i;
        }
        sb.append(ET).append(AID_ADDRESSES).append(CT);
        sb.append(ET).append(AID_TAG).append(CT);
    }

    private static void encodeTag(StringBuffer sb, String tag, String content) {
        sb.append(OT).append(tag).append(CT);
        sb.append(content);
        sb.append(ET).append(tag).append(CT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeProp(StringBuffer sb, Property p) {
        String v = null;
        Object o = p.getValue();
        String type = PROP_STRING_TYPE;
        if (o instanceof String) {
            v = (String)o;
        } else if (o instanceof byte[]) {
            type = PROP_BYTE_TYPE;
            try {
                v = new String(Base64.encodeBase64((byte[])((byte[])o)), "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            if (!(o instanceof Serializable)) return;
            type = PROP_SER_TYPE;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(o);
                oos.close();
                byte[] bytes = bos.toByteArray();
                if (bytes != null) {
                    v = new String(Base64.encodeBase64((byte[])bytes), "US-ASCII");
                }
            }
            catch (IOException ioe) {
                return;
            }
        }
        sb.append(OT).append(PROP_TAG).append(" ");
        sb.append(PROP_ATTR).append("=\"").append(p.getName()).append("\" ");
        sb.append(PROP_ATTR_TYPE).append("=\"").append(type).append("\"");
        sb.append(CT);
        sb.append(v);
        sb.append(ET).append(PROP_TAG).append(CT);
    }

    private void decodeProp(StringBuffer acc, Property p) {
        if (this.propType.equals(PROP_SER_TYPE)) {
            try {
                byte[] serdata = acc.toString().getBytes("US-ASCII");
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((byte[])serdata)));
                p.setValue((Serializable)ois.readObject());
            }
            catch (Exception e) {}
        } else if (this.propType.equals(PROP_BYTE_TYPE)) {
            byte[] bytes = null;
            try {
                bytes = acc.toString().getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            p.setValue(Base64.decodeBase64((byte[])bytes));
        } else {
            p.setValue(acc.toString());
        }
        this.propType = null;
    }

    private static void encodeOneLineTag(StringBuffer sb, String tag1, String tag2, String value) {
        sb.append(OT).append(tag1).append(" ");
        sb.append(tag2).append("=\"").append(value).append("\"/>");
    }

    public static synchronized String encodeXML(Envelope env) {
        BasicFipaDateTime date;
        StringBuffer sb = new StringBuffer(PREAMBUL);
        sb.append(OT).append(ENVELOPE_TAG).append(CT);
        sb.append(OT).append(PARAMS_TAG).append(INDEX_ATTR).append(1).append("\"").append(CT);
        Iterator i = env.getAllTo();
        while (i.hasNext()) {
            sb.append(OT).append(TO_TAG).append(CT);
            XMLCodec.encodeAid(sb, (AID)i.next());
            sb.append(ET).append(TO_TAG).append(CT);
        }
        if (env.getFrom() != null) {
            sb.append(OT).append(FROM_TAG).append(CT);
            XMLCodec.encodeAid(sb, env.getFrom());
            sb.append(ET).append(FROM_TAG).append(CT);
        }
        if (env.getComments() != null && env.getComments().length() > 0) {
            XMLCodec.encodeTag(sb, COMMENTS_TAG, env.getComments());
        }
        if (env.getAclRepresentation() != null) {
            XMLCodec.encodeTag(sb, REPRESENTATION_TAG, env.getAclRepresentation());
        }
        if (env.getPayloadLength() != null) {
            XMLCodec.encodeTag(sb, LENGTH_TAG, String.valueOf(env.getPayloadLength()));
        }
        if (env.getPayloadEncoding() != null && env.getPayloadEncoding().length() > 0) {
            XMLCodec.encodeTag(sb, ENCODING_TAG, env.getPayloadEncoding());
        }
        if ((date = new BasicFipaDateTime(env.getDate())) != null) {
            XMLCodec.encodeTag(sb, DATE_TAG, date.toString());
        }
        i = env.getAllIntendedReceiver();
        while (i.hasNext()) {
            sb.append(OT).append(INTENDED_TAG).append(CT);
            XMLCodec.encodeAid(sb, (AID)i.next());
            sb.append(ET).append(INTENDED_TAG).append(CT);
        }
        i = env.getAllProperties();
        while (i.hasNext()) {
            XMLCodec.encodeProp(sb, (Property)i.next());
        }
        ReceivedObject ro = env.getReceived();
        if (ro != null) {
            sb.append(OT).append(RECEIVED_TAG).append(CT);
            String value = new BasicFipaDateTime(ro.getDate()).toString();
            if (value != null) {
                XMLCodec.encodeOneLineTag(sb, RECEIVED_DATE, RECEIVED_ATTR, value);
            }
            if ((value = ro.getBy()) != null && !value.equals(NULL)) {
                XMLCodec.encodeOneLineTag(sb, RECEIVED_BY, RECEIVED_ATTR, value);
            }
            if ((value = ro.getFrom()) != null && !value.equals(NULL)) {
                XMLCodec.encodeOneLineTag(sb, RECEIVED_FROM, RECEIVED_ATTR, value);
            }
            if ((value = ro.getId()) != null && !value.equals(NULL)) {
                XMLCodec.encodeOneLineTag(sb, RECEIVED_ID, RECEIVED_ATTR, value);
            }
            if ((value = ro.getVia()) != null && !value.equals(NULL)) {
                XMLCodec.encodeOneLineTag(sb, RECEIVED_VIA, RECEIVED_ATTR, value);
            }
            sb.append(ET).append(RECEIVED_TAG).append(CT);
        }
        sb.append(ET).append(PARAMS_TAG).append(CT);
        sb.append(ET).append(ENVELOPE_TAG).append(CT);
        return sb.toString();
    }

    public void startDocument() {
        this.env = new Envelope();
    }

    public void endDocument() {
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        this.accumulator = new StringBuffer();
        if (TO_TAG.equalsIgnoreCase(localName)) {
            this.aid = new AID();
            this.env.addTo(this.aid);
        } else if (FROM_TAG.equalsIgnoreCase(localName)) {
            this.aid = new AID();
            this.env.setFrom(this.aid);
        } else if (INTENDED_TAG.equalsIgnoreCase(localName)) {
            this.aid = new AID();
            this.env.addIntendedReceiver(this.aid);
        } else if (RECEIVED_TAG.equalsIgnoreCase(localName)) {
            this.ro = new ReceivedObject();
            this.env.addStamp(this.ro);
        } else if (RECEIVED_BY.equalsIgnoreCase(localName)) {
            this.ro.setBy(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_FROM.equalsIgnoreCase(localName)) {
            this.ro.setFrom(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_DATE.equalsIgnoreCase(localName)) {
            this.ro.setDate(new BasicFipaDateTime(attributes.getValue(RECEIVED_ATTR)).getTime());
        } else if (RECEIVED_ID.equalsIgnoreCase(localName)) {
            this.ro.setId(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_VIA.equalsIgnoreCase(localName)) {
            this.ro.setVia(attributes.getValue(RECEIVED_ATTR));
        } else if (PROP_TAG.equalsIgnoreCase(localName)) {
            this.prop = new Property();
            this.env.addProperties(this.prop);
            this.prop.setName(attributes.getValue(PROP_ATTR));
            this.propType = attributes.getValue(PROP_ATTR_TYPE);
        }
    }

    public void endElement(String namespaceURL, String localName, String qname) {
        if (AID_NAME.equalsIgnoreCase(localName)) {
            this.aid.setName(this.accumulator.toString());
        } else if (AID_ADDRESS.equalsIgnoreCase(localName)) {
            this.aid.addAddresses(this.accumulator.toString());
        } else if (COMMENTS_TAG.equalsIgnoreCase(localName)) {
            this.env.setComments(this.accumulator.toString());
        } else if (REPRESENTATION_TAG.equalsIgnoreCase(localName)) {
            this.env.setAclRepresentation(this.accumulator.toString());
        } else if (LENGTH_TAG.equalsIgnoreCase(localName)) {
            this.env.setPayloadLength(new Long(this.accumulator.toString()));
            if (logger.isLoggable(9)) {
                logger.log(5, "Length: " + this.env.getPayloadLength());
            }
        } else if (ENCODING_TAG.equalsIgnoreCase(localName)) {
            this.env.setPayloadEncoding(this.accumulator.toString());
        } else if (DATE_TAG.equalsIgnoreCase(localName)) {
            this.env.setDate(new BasicFipaDateTime(this.accumulator.toString()).getTime());
        } else if (PROP_TAG.equalsIgnoreCase(localName)) {
            this.decodeProp(this.accumulator, this.prop);
        }
    }

    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public void warning(SAXParseException exception) {
        if (logger.isLoggable(9)) {
            logger.log(9, " line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    public void error(SAXParseException exception) {
        if (logger.isLoggable(9)) {
            logger.log(9, "ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(9)) {
            logger.log(10, "FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
        throw exception;
    }

    public Envelope parse(Reader in) throws MTPException {
        try {
            this.parser.parse(new InputSource(in));
            return this.env;
        }
        catch (Exception ex) {
            throw new MTPException(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

